function display_features1(file1,imf1)
%
%Displays affine regions on the image
%
%disp_features(file1,imf1,dx,dy)
%
%file1 - 'filename' - ASCII file with affine regions
%imf1 - 'filename'- image
%dx - shifts all the regions in the image by dx  
%dy - shifts all the regions in the image by dy
%
%example:
%disp_features('img1.haraff','img1.ppm',0,0)

%[feat1, nb, dim]=loadFeatures2(file1);
[feat1, nb, dim]=loadFeatures(file1);
figure;imshow(imf1);
% 0001idx = [101,191,253,131,256,266];
%0046 idx = [110,129,348,377,376,137,114,124];
%0049 idx = [247,268,329,363,359,333];
% 0078 idx = [137,148,147,215,201,131,40,199];
%0097  idx = [176,37,79,284,45];
% 0115 idx = [30,36,37,54,201,58,24,39,286];
%0139 idx = [95,50,142,99,141,157];
%0159 idx = [34,50,52,195,207,43];
%0167 idx = [164,167,276,180,176,31,306,294];
% 0211 idx = [42,149,160,145,201];
% 0230 idx = [159,63,235,259,234];
%0311 idx = [174,191,16,243,262];

% idx = [32 34 50 131 31 9 58 87 133 162 191 208 233 259 234 209 134 35 88 33 10 269 277 283 290 40 177 182 211 89 59 163 210 252 91 37 253 235 135 164 150 60 52 90 270 278 284 289 93 61 104 170 175 140 144 113 171 141 199 219 242 258 272 281 287 291 293 295 227 264 273 288 296 294 292];
% nb = length(idx);
% feat1 = feat1(:,idx);

for c1=1:nb,%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    drawellipse([feat1(3,c1) feat1(4,c1); feat1(4,c1) feat1(5,c1) ], feat1(1,c1), feat1(2,c1),'y');
    %text(feat1(1,c1), feat1(2,c1), num2str(c1),'Color','y');
end%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%u,v,a,b,c    in    a(x-u)(x-u)+2b(x-u)(y-v)+c(y-v)(y-v)=1
% u = feat1(1,c1)+dx: the x corrdinates of the center of the ellipse
% v = feat1(2,c1)+dy: the y corrdinates of the center of the ellipse
% a = feat1(3,c1);
% b = feat1(4,c1);
% c = feat1(5,c1);
function drawellipse(Mi,i,j,col)
hold on;
[v e]=eig(Mi);

l1=1/sqrt(e(1));

l2=1/sqrt(e(4));

alpha=atan2(v(4),v(3));
s=1;
t = 0:pi/50:2*pi;
y=s*(l2*sin(t));
x=s*(l1*cos(t));

xbar=x*cos(alpha) + y*sin(alpha);
ybar=y*cos(alpha) - x*sin(alpha);
%plot(ybar+i,xbar+j,'-k','LineWidth',4);
plot(ybar+i,xbar+j,col,'LineWidth',3);
%col='-k';
%plot([i-2 i+2],[j j],col,'LineWidth',3);
%plot([i i],[j-2 j+2],col,'LineWidth',3);
set(gca,'Position',[0 0 1 1]);
hold off;


function [feat, nb, dim]=loadFeatures(file)
fid = fopen(file, 'r');
dim=fscanf(fid, '%f',1);
if dim==1
dim=0;
end
nb=fscanf(fid, '%d',1);
feat = fscanf(fid, '%f', [5+dim, inf]);
fclose(fid);


function [feat, nb, dim]=loadFeatures2(file)
fid = fopen(file, 'r');
dim=fscanf(fid, '%f',1);
if dim==1
dim=128;
end
nb=fscanf(fid, '%d',1);
feat = fscanf(fid, '%f', [5+dim, inf]);
fclose(fid);
