#include <GL/gl.h>

struct vertex
{
	float	position[3];
	float	normal[3];
	float	texCoord[2];
};

struct vertex VertexData[ ] =
{
	// triangle 0-2-3:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{  0.,  0., -1. },
		{  1., 0. }
	},

	// vertex #2:
	{
		{ -1.,  1., -1. },
		{  0.,  0., -1. },
		{  1., 1. }
	},

	// vertex #3:
	{
		{  1.,  1., -1. },
		{  0.,  0., -1. },
		{  0., 1. }
	},


	// triangle 0-3-1:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{  0.,  0., -1. },
		{  1., 0. }
	},

	// vertex #3:
	{
		{  1.,  1., -1. },
		{  0.,  0., -1. },
		{  0., 1. }
	},

	// vertex #1:
	{
		{  1., -1., -1. },
		{  0.,  0., -1. },
		{  0., 0. }
	},


	// triangle 4-5-7:
	// vertex #4:
	{
		{ -1., -1.,  1. },
		{  0.,  0.,  1. },
		{  0., 0. }
	},

	// vertex #5:
	{
		{  1., -1.,  1. },
		{  0.,  0.,  1. },
		{  1., 0. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  0.,  0.,  1. },
		{  1., 1. }
	},


	// triangle 4-7-6:
	// vertex #4:
	{
		{ -1., -1.,  1. },
		{  0.,  0.,  1. },
		{  0., 0. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  0.,  0.,  1. },
		{  1., 1. }
	},

	// vertex #6:
	{
		{ -1.,  1.,  1. },
		{  0.,  0.,  1. },
		{  0., 1. }
	},


	// triangle 1-3-7:
	// vertex #1:
	{
		{  1., -1., -1. },
		{  1.,  0.,  0. },
		{  1., 0. }
	},

	// vertex #3:
	{
		{  1.,  1., -1. },
		{  1.,  0.,  0. },
		{  1., 1. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  1.,  0.,  0. },
		{  0., 1. }
	},


	// triangle 1-7-5:
	// vertex #1:
	{
		{  1., -1., -1. },
		{  1.,  0.,  0. },
		{  1., 0. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  1.,  0.,  0. },
		{  0., 1. }
	},

	// vertex #5:
	{
		{  1., -1.,  1. },
		{  1.,  0.,  0. },
		{  0., 0. }
	},


	// triangle 0-4-6:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{ -1.,  0.,  0. },
		{  0., 0. }
	},

	// vertex #4:
	{
		{ -1., -1.,  1. },
		{ -1.,  0.,  0. },
		{  1., 0. }
	},

	// vertex #6:
	{
		{ -1.,  1.,  1. },
		{ -1.,  0.,  0. },
		{  1., 1. }
	},


	// triangle 0-6-2:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{ -1.,  0.,  0. },
		{  0., 0. }
	},

	// vertex #6:
	{
		{ -1.,  1.,  1. },
		{ -1.,  0.,  0. },
		{  1., 1. }
	},

	// vertex #2:
	{
		{ -1.,  1., -1. },
		{ -1.,  0.,  0. },
		{  0., 1. }
	},


	// triangle 2-6-7:
	// vertex #2:
	{
		{ -1.,  1., -1. },
		{  0.,  1.,  0. },
		{  0., 1. }
	},

	// vertex #6:
	{
		{ -1.,  1.,  1. },
		{  0.,  1.,  0. },
		{  0., 0. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  0.,  1.,  0. },
		{  1., 0. }
	},


	// triangle 2-7-3:
	// vertex #2:
	{
		{ -1.,  1., -1. },
		{  0.,  1.,  0. },
		{  0., 1. }
	},

	// vertex #7:
	{
		{  1.,  1.,  1. },
		{  0.,  1.,  0. },
		{  1., 0. }
	},

	// vertex #3:
	{
		{  1.,  1., -1. },
		{  0.,  1.,  0. },
		{  1., 1. }
	},


	// triangle 0-1-5:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{  0., -1.,  0. },
		{  0.,  0. }
	},

	// vertex #1:
	{
		{  1., -1., -1. },
		{  0., -1.,  0. },
		{  1.,  0. }
	},

	// vertex #5:
	{
		{  1., -1.,  1. },
		{  0., -1.,  0. },
		{  1.,  1. }
	},


	// triangle 0-5-4:
	// vertex #0:
	{
		{ -1., -1., -1. },
		{  0., -1.,  0. },
		{  0.,  0. }
	},

	// vertex #5:
	{
		{  1., -1.,  1. },
		{  0., -1.,  0. },
		{  1.,  1. }
	},

	// vertex #4:
	{
		{ -1., -1.,  1. },
		{  0., -1.,  0. },
		{  0.,  1. }
	},
};

void
OsuCube( float side )
{
	glPushMatrix( );
		glScalef( .5f*side, .5f*side, .5f*side );	// the given coords go from -1. to 1.
		glBegin( GL_TRIANGLES );
			for( int i = 0; i < 36; i++ )
			{
				glNormal3fv(   VertexData[i].normal );
				glTexCoord2fv( VertexData[i].texCoord );
				glVertex3fv(   VertexData[i].position );
			}
		glEnd( );
	glPopMatrix( );
}
