//
// 4x3 maze problem solved by value iteration.
//
//
#include "4x3.h"
#include "mdp.h"
#include <stdlib.h>
int VERBOSE = 0;
int BackupCounter = 0;
int OldPopCounter = 0;
int MCinterval = 10;
int MCNSteps = 1000;
int MCpolicy = 0;  // greedy

int main(int argc, char	* argv[])
{
  FourBy3Problem  problem;
  MDP<FourBy3State, FourBy3Action> mdp(&problem);

  extern char getopt(int, char *[], char *);
  extern char *	optarg;
  char optc;
  float	epsilon	= 0.01;
  int n	= 10;

  while	(( optc	= getopt(argc, argv, "e:n:v")) != -1 ) {
    switch (optc) {
    case 'e':
      epsilon =	atof(optarg);
      cout << "epsilon = " << epsilon << endl;
      break;
    case 'n':
      n	= atoi(optarg);
      cout << "n = " <<	n << endl;
      break;
    case 'v':
      VERBOSE =	1;
      cout << "verbose = 1" << endl;
      break;
    default:
      cout << "Usage: 4x3vi [-n	n] [-e epsilon]	[-v]" << endl;
      cout << "	-e epsilon	   set convergence tolerance" << endl;
      cout << "	-n n		   number of psweep steps per Bellman  backup" << endl;
      cout << "	-v		   turn	on VERBOSE output" << endl;
      return 1;
    }
  }

  mdp.PrioritizedSweeping(n, epsilon);

  // now print out the value function
  FourBy3StateIterator itr;
  for (itr.init(); !itr; ++itr)	{
    cout << itr().n1 <<	" " << itr().n2	<< " " << mdp.Vfunction(itr())
	 << endl;
  }
  return 0;
}
