//
// windy maze problem solved by	value iteration.
//
//
#include "windy.h"
#include "mdp.h"
#include <stdlib.h>
#include <stdio.h>
int VERBOSE = 0;
int BackupCounter = 0;
int OldPopCounter = 0;
int MCinterval = 10;
int MCNSteps = 1000;
int MCpolicy = 0;  // greedy

int main(int argc, char	* argv[])
{
  WindyProblem	problem;
  MDP<WindyState, WindyAction> mdp(&problem);

  extern char getopt(int, char *[], char *);
  extern char *	optarg;
  char optc;
  float	epsilon	= 0.01;
  int n	= 10;

  while	(( optc	= getopt(argc, argv, "e:n:v")) != -1 ) {
    switch (optc) {
    case 'e':
      epsilon =	atof(optarg);
      cout << "epsilon = " << epsilon << endl;
      break;
    case 'n':
      n	= atoi(optarg);
      cout << "n = " <<	n << endl;
      break;
    case 'v':
      VERBOSE =	1;
      cout << "verbose = 1" << endl;
      break;
    default:
      cout << "Usage: windypsweep [-e epsilon] [-n n] [-v]" << endl;
      cout << "	-e epsilon	   set convergence tolerance" << endl;
      cout << "	-n n		   number of psweep steps per Bellman  backup" << endl;
      cout << "	-v		   turn	on VERBOSE output" << endl;
      return 1;
    }
  }

  mdp.PrioritizedSweeping(n, epsilon);

  cout << "Value function:" << endl;
  // now print out the value function
  for (int irow	= NROWS	- 1; irow >= 0;	irow--)	{
    printf("%2d	", irow);
    for	(int icol = 0; icol < NCOLUMNS;	icol++)	{
      WindyState s(icol, irow);
      printf(" %3.0f", mdp.Vfunction(s));
    }
    printf("\n");
  }
  printf("   ");
  for (int icol	= 0; icol < NCOLUMNS; icol++) {
    printf(" %3d", icol);
  }
  printf("\n");

  cout << "Policy: " <<	endl;
  for (int irow	= NROWS	- 1; irow >= 0;	irow--)	{
    printf("%2d	", irow);
    for	(int icol = 0; icol < NCOLUMNS;	icol++)	{
      WindyState s(icol, irow);
      WindyAction a = mdp.greedyPolicy(s);
      switch (a) {
      case North: cout <<  "  ^	"; break;
      case South: cout <<  "  V	"; break;
      case East: cout << "  > "; break;
      case West: cout << "  < "; break;
      }
    }
    printf("\n");
  }
  printf("   ");
  for (int icol	= 0; icol < NCOLUMNS; icol++) {
    printf(" %3d", icol);
  }
  printf("\n");



  return 0;
}
